/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_5546;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

public class CantBreatheAirChallenge
extends Challenge {
    private static final int MAX_AIR = 300;
    private static final int DAMAGE_INTERVAL = 40;
    private static final float DAMAGE_AMOUNT = 2.0f;
    private int tickCounter = 0;
    private boolean lavaDamageEnabled = true;
    private Map<UUID, Integer> playerAirLevels = new HashMap<UUID, Integer>();

    public CantBreatheAirChallenge() {
        super("cant_breathe_air", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_breathe_air.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_breathe_air.description"), false, Challenge.MultiplayerStatus.EXPERIMENTAL);
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    public boolean isLavaDamageEnabled() {
        return this.lavaDamageEnabled;
    }

    public void setLavaDamageEnabled(boolean enabled) {
        this.lavaDamageEnabled = enabled;
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.tickCounter = 0;
        this.playerAirLevels.clear();
    }

    @Override
    public void onDisable() {
        this.playerAirLevels.clear();
    }

    public boolean isInLiquid(class_1657 player) {
        return player.method_5869() || player.method_5777(class_3486.field_15518);
    }

    public boolean isInCauldron(class_1657 player) {
        class_2338 pos = player.method_24515();
        class_2680 blockState = player.method_37908().method_8320(pos);
        return blockState.method_26204() instanceof class_5546;
    }

    public boolean isInRainOrSnow(class_1657 player) {
        boolean isRaining = player.method_37908().method_8419();
        boolean canSeeSky = player.method_37908().method_8311(player.method_24515());
        return isRaining && canSeeSky;
    }

    public boolean isSuffocating(class_1657 player) {
        class_2338 headPos = player.method_24515().method_10084();
        class_2680 headBlock = player.method_37908().method_8320(headPos);
        if (headBlock.method_27852(class_2246.field_27879) || headBlock.method_27852(class_2246.field_10255) || headBlock.method_27852(class_2246.field_10102)) {
            return true;
        }
        return headBlock.method_26234((class_1922)player.method_37908(), headPos);
    }

    public int getPlayerAir(class_1657 player) {
        return this.playerAirLevels.getOrDefault(player.method_5667(), 300);
    }

    public void setPlayerAir(class_1657 player, int air) {
        this.playerAirLevels.put(player.method_5667(), Math.max(-20, Math.min(300, air)));
    }

    public void resetPlayerAir(class_1657 player) {
        this.playerAirLevels.put(player.method_5667(), 300);
        player.method_5855(300);
    }

    private int getRespirationLevel(class_1657 player) {
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        if (helmet.method_7960()) {
            return 0;
        }
        class_9304 enchantments = class_1890.method_57532((class_1799)helmet);
        for (Object2IntMap.Entry entry : enchantments.method_57539()) {
            if (!((class_6880)entry.getKey()).method_40225(class_1893.field_9127)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    public void refillPlayerAir(class_1657 player) {
        if (!this.isEnabled() || player.method_7325() || player.method_68878()) {
            return;
        }
        this.playerAirLevels.put(player.method_5667(), 300);
        player.method_5855(300);
    }

    public void tickAir(class_1657 player) {
        if (!this.isEnabled() || player.method_7325() || player.method_68878()) {
            return;
        }
        ++this.tickCounter;
        int currentAir = this.getPlayerAir(player);
        boolean fullySubmerged = this.isInLiquid(player);
        boolean inRainOrSnow = this.isInRainOrSnow(player);
        boolean touchingWater = player.method_5799();
        boolean inLava = player.method_5771();
        boolean suffocating = this.isSuffocating(player);
        boolean inCauldron = this.isInCauldron(player);
        boolean hasWaterBreathing = player.method_6059(class_1294.field_5923);
        boolean hasConduitPower = player.method_6059(class_1294.field_5927);
        boolean isRaining = player.method_37908().method_8419();
        boolean canBreathe = false;
        if (fullySubmerged) {
            canBreathe = true;
        } else if (suffocating) {
            canBreathe = true;
        } else if (inCauldron) {
            canBreathe = true;
        } else if (inRainOrSnow) {
            canBreathe = true;
        } else if (isRaining && (touchingWater || inLava)) {
            canBreathe = true;
        } else if (hasWaterBreathing || hasConduitPower) {
            canBreathe = true;
        }
        if (canBreathe) {
            if (currentAir < 300) {
                this.setPlayerAir(player, currentAir + 4);
            }
        } else {
            int respirationLevel = this.getRespirationLevel(player);
            int airLossInterval = 2 + respirationLevel;
            if (this.tickCounter % airLossInterval == 0) {
                this.setPlayerAir(player, currentAir - 1);
            }
            if (this.tickCounter % 40 == 0 && currentAir < 60) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u26a0 DANGER"), true);
            }
            if (currentAir <= -20 && this.tickCounter % 40 == 0) {
                class_1937 class_19372;
                float currentHealth = player.method_6032();
                if (player instanceof class_3222 && (class_19372 = player.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    float damageAmount = Math.min(2.0f, currentHealth);
                    player.method_64397(serverWorld, serverWorld.method_48963().method_48824(), damageAmount);
                } else {
                    player.method_6033(Math.max(0.0f, currentHealth - 2.0f));
                }
            }
        }
        this.updateAirDisplay(player, currentAir);
    }

    private void updateAirDisplay(class_1657 player, int customAir) {
        if (player.method_5669() != customAir) {
            player.method_5855(customAir);
        }
    }

    @Override
    public String getShowcaseVideoUrl() {
        return "https://youtu.be/LhTDKGT6Kqo";
    }
}

